--***********************************************************
--**                    ShadowCop		                   **
--**        Info Window on Campfire for Crematorium        **
--***********************************************************

require "ISUI/ISCollapsableWindow"

ISChainsawRevolutionInfoWindow = ISCollapsableWindow:derive("ISChainsawRevolutionInfoWindow")
ISChainsawRevolutionInfoWindow.windows = {}

function ISChainsawRevolutionInfoWindow:createChildren()
	ISCollapsableWindow.createChildren(self)
	self.panel = ISToolTip:new()
	self.panel.followMouse = false
	self.panel:initialise()
	self:setObject(self.object)
	self:addView(self.panel)
end

function ISChainsawRevolutionInfoWindow:update()
	ISCollapsableWindow.update(self)
	
	if self:getIsVisible() and not self.object then
		if self.joyfocus then
			self.joyfocus.focus = nil
			updateJoypadFocus(self.joyfocus)
		end
		self:removeFromUIManager()
		return
	end
	
	if self.FuelAmt ~= self.object:getModData().FuelAmt or self.Run ~= self.object:getModData().Run then
		self:setObject(self.object)
	end
	self:setWidth(self.panel:getWidth())
	self:setHeight(self:titleBarHeight() + self.panel:getHeight())
end

function ISChainsawRevolutionInfoWindow:onJoypadDown(button)
	if button == Joypad.BButton then
		self:removeFromUIManager()
		setJoypadFocus(self.playerNum, nil)
	end
end

function ISChainsawRevolutionInfoWindow:setObject(chainsaw)
	self.object = chainsaw
	self.panel:setName(getText("IGUI_Chainsaw"))	
	self.FuelAmt = chainsaw:getModData().FuelAmt
	self.Run = chainsaw:getModData().Run
	if self.Run == true then
		self.Status = getText("IGUI_Chainsaw_Run")
	else
		self.Status = getText("IGUI_Chainsaw_Stop")
	end
	self.panel:setTexture(chainsaw:getTexture():toString())
	self.panel.description = getText("IGUI_Chainsaw_FuelAmount", round((self.FuelAmt / 120 * 100), 1) .. "%") .. ", " .. self.Status
end

function ISChainsawRevolutionInfoWindow:onGainJoypadFocus(joypadData)
	self.drawJoypadFocus = true
end

function ISChainsawRevolutionInfoWindow:close()
	self:removeFromUIManager()
end

function ISChainsawRevolutionInfoWindow:new(x, y, character, chainsaw)
	local width = 320
	local height = 16 + 64 + 16 + 16
	local o = ISCollapsableWindow:new(x, y, width, height)
	setmetatable(o, self)
	self.__index = self
	o.character = character
	o.playerNum = character:getPlayerNum()
	o.object = chainsaw
	o:setResizable(false)
	return o
end
